<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:cfg="." xmlns:user="http://bosch.com">
  <!--
BOSCH Security Sytems (Ottobrunn)
Project: Magic.Panel
Author: Michael Ziegel
Created: 16.09.2006
$Archive:   //ot1esw2/MagicPanel/PVCS MP-SW/archives/MP_SW/MP_PC_SW/Transformer/Conversion/XSLT/conv-1-0-0-to-1-1-0.xsl-arc  $  
$Revision: 1.23 $ 
Last locked:   $Date: 2017/04/18 13:26:53GMT $
Last change by $Author: Maria Lux (lux2ot) $
History: 
$Log: XSLT/conv-main.xsl  $
Revision 1.23 2017/04/18 13:26:53GMT Maria Lux (lux2ot) 
checking of version adapted
Revision 1.22 2015/05/21 15:03:03CEST Maria Lux (lux2ot) 
new function IsVersionLess added
Revision 1.20 2015/01/09 10:32:56MEZ Maria Lux (lux2ot) 
new schema 13.2 supported
Revision 1.19 2014/07/04 10:01:47MESZ Maria Lux (lux2ot) 
removed adding of conversion-comments
Revision 1.18 2014/06/16 10:29:08MESZ Maria Lux (lux2ot) 
always initialize xmlValidation and mismatchConfirmed
Revision 1.17 2014/04/25 12:47:20MESZ Maria Lux (lux2ot) 
changes for MP_FT_SYSTEMSTATUS; 
corrections of conversions
Revision 1.16 2014/04/14 11:11:06MESZ Maria Lux (lux2ot) 
added some functions for tracing upgrades
Revision 1.15 2014/04/02 14:52:13MESZ Maria Lux (lux2ot) 
new namespace added to avoid problems with Altive XML Spy
Revision 1.14 2013/11/21 16:51:15MEZ Maria Lux (lux2ot) 
adaption for HEADER moved from conv-lt-2-10-0-to2-10-0.xsl to this file
Revision 1.13 2008/10/06 12:23:32CEST Michael Ziegel (zi82ot) 
Member moved from Conversion/XSLT/conv-main.xsl in project f:/MKS_Repository/Fire/MagicPanel/Source/PCTools/Transformer/Transformer.pj to XSLT/conv-main.xsl in project f:/MKS_Repository/Fire/MagicPanel/Source/PCTools/RPSTools/XMLSupport/XMLSupport.pj.
Revision 1.12 2008/10/06 12:23:32CEST Michael Ziegel (zi82ot) 
revision control added
Revision 1.11 2008/03/13 14:40:21CET zi82ot 
Tidyup conversion. V 2.0.7 supported
Revision 1.10 2008/03/04 13:23:46CET zi82ot 
Dont copy rpsLanguage to force creation of trieview texts by RPS.
Revision 1.9 2007/03/13 15:38:52CET zi82ot 
HEADER/adapted only written when existing
Revision 1.8 2007/03/13 15:18:51CET zi82ot 
copy attributes of modified nodes, create HEADER for LOCAL_CONFIG
Revision 1.7 2007/03/13 11:36:38CET zi82ot 
Attribute rpsLanguage of HEADER is copied
Revision 1.6 2007/03/13 10:00:08CET zi82ot 
template update header
Revision 1.5 2006/12/07 17:22:54CET zi82ot 
add HEADER/adapted not conditional
Revision 1.4 2006/12/04 13:22:35CET zi82ot 
write HEADER/adapted only if not already there, otherwise two elementas could be created
Revision 1.3 2006/11/29 13:42:21CET zi82ot 
For versions 1.3.0 and 2.0.0 HEADER iis converted to new structure
Revision 1.2 2006/11/28 18:32:14CET zi82ot 
New HEADER structure supported
Revision 1.1 2006/09/18 08:57:33CEST zi82ot 
Initial revision
Member added to project f:/MKS_Repository/Fire/MagicPanel/Source/PCTools/Transformer/Transformer.pj
-->
  <cfg:Stylesheet version="$Revision: 1.23 $"/>
  <xsl:output method="xml" indent="yes"/>
  <!-- the parameter newversion is automatically set by the TrafoValidate engine to the value of 'toVersion' of the conversion which is actually performed.
        Thus the element HEADER/dataVersion is set automatically to the new version.
  -->
  <xsl:param name="newversion" select="'0.0.0'"/>
  <xsl:param name="Converted"/>
  <xsl:param name="ConvertedFrom"/>
  <!--****************  GENERIC PART iterate thru all nodes and copy elements and attribute ***********************-->
  <!-- copies each node implicitly by match 'node()', the attributes need to be copied explicitly by template @*-->
  <xsl:template match="*">
    <xsl:element name="{name()}">
      <xsl:apply-templates select="node()">
    </xsl:apply-templates>
    </xsl:element>
  <!-- explicitly copy comments -->
      <xsl:apply-templates select="comment()">
    </xsl:apply-templates>
</xsl:template>
  <!-- explicitly copy attributes -->
  <!-- we do not copy attributes anymore (exception panelEncoding). Thus we force the creation of new rpsDisplayNames, which have been wrong in some RPS-versions  -->
  <xsl:template match="@*">
	  <xsl:choose>
			<xsl:when test="name()='rpsDisplayName'">
				  <!-- remove the attribute rpsDisplayname-->
				  <!--xsl:comment>rpsDisplayname removed</xsl:comment-->
			</xsl:when>
			<xsl:otherwise>
				<xsl:copy/>
				  <!--xsl:comment>attribute <xsl:value-of select="name()"/> copied</xsl:comment-->
			</xsl:otherwise>
		</xsl:choose>
  </xsl:template>
  <!-- explicitly copy comments -->
  <xsl:template match="comment()">
    <xsl:copy/>
  </xsl:template>
  
  <!-- explicitly copy attributes of a certain nodeset
  <xsl:template name="CopyAttributesOf">
    <xsl:param name="Element"/>
    <xsl:for-each select="$Element">
      <xsl:attribute name="{name()}"><xsl:value-of select="."/></xsl:attribute>
    </xsl:for-each>
  </xsl:template>
-->
  <!--****************  SPECIAL PART modifications to certain nodes ***********************-->
  <!-- Header must be copied and updated-->
  <xsl:template match="HEADER">
	<xsl:call-template name="InsertConversionComment">
		<xsl:with-param name="structureName"><xsl:value-of select="name()"/></xsl:with-param>
	</xsl:call-template> 
    <xsl:element name="HEADER">
      <!-- do not copy rpsLanguage to force RPS to rebuild all display texts in any case. There are previous versions of RPS which have created 
         rpsDisplayName values which show wrong information. E.g. GROUND siNumber = 1 but only the text Ground without number is displayed, 
         leading to confusion. -->
      <xsl:element name="filename">
        <xsl:value-of select="filename"/>
      </xsl:element>
      <xsl:element name="revNumber">
        <xsl:value-of select="revNumber"/>
      </xsl:element>
      <xsl:element name="lastModified">
        <xsl:value-of select="lastModified"/>
      </xsl:element>
      <xsl:element name="dataVersion">
        <xsl:value-of select="$newversion"/>
      </xsl:element>
      <xsl:call-template name="ExtendHeader"/>
    </xsl:element>
  </xsl:template>
  <!-- Header must be copied and updated-->
  <xsl:template name="ExtendHeader">
    <xsl:if test="user:IsVersionGreaterOrEqual($newversion,'1.3.0')">
      <xsl:element name="converted">
        <xsl:choose>
          <xsl:when test="$Converted">
            <xsl:value-of select="$Converted"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="converted"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:element>
      <xsl:element name="convertedFrom">
        <xsl:choose>
          <xsl:when test="$ConvertedFrom">
            <xsl:value-of select="$ConvertedFrom"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="convertedFrom"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:element>
    </xsl:if>
          <xsl:if test="user:IsVersionGreaterOrEqual($newversion,'2.10.0')">
  <!-- ################################## NEW in VERSION 2.10.0 ######################## -->
	<!-- always reset xmlValidation and mismatchConfirmed; there are always changes and the xmlValidation-value is no longer valid -->
		<xsl:element name="xmlValidation">
			<xsl:text>0000</xsl:text>
		</xsl:element>
		<xsl:element name="mismatchConfirmed">
			<xsl:text></xsl:text>
		</xsl:element>
  <!-- ################################## END NEW in VERSION 2.10.0 ######################## -->
    </xsl:if>
    <xsl:if test="user:IsVersionGreaterOrEqual($newversion,'1.3.0')">
      <!-- force a new adaption on each conversion
      <xsl:if test="adapted = true()">
        <xsl:element name="adapted">
          <xsl:value-of select="adapted"/>
        </xsl:element>
      </xsl:if>
      -->
		<!--xsl:apply-templates select="adapted"/-->
		<xsl:choose>
			<xsl:when test="adapted = false()">
				<xsl:element name="adapted">
					<xsl:text></xsl:text>
				</xsl:element>
			</xsl:when>
			<xsl:otherwise>
			<xsl:apply-templates select="adapted"/>
			</xsl:otherwise>
		</xsl:choose>
    </xsl:if>
  </xsl:template>
  <!-- -->
  <xsl:template name="InsertConversionComment">
	  <xsl:param name="structureName"/>
<!-- currently not used	  
	<xsl:comment>
		<xsl:text>updated by template </xsl:text><xsl:value-of select="$structureName"/><xsl:text> </xsl:text>
		<xsl:value-of select="user:GetCurrentDateTime()"/>
		<xsl:text> converted from </xsl:text><xsl:value-of select="$ConvertedFrom"/><xsl:text> to </xsl:text><xsl:value-of select="$newversion"/>
	</xsl:comment>
-->
  </xsl:template>
  <!-- -->
  <!-- -->
  <xsl:template name="InsertConversionCommentWithMode">
	  <xsl:param name="structureName"/>
	  <xsl:param name="myMode"/>
<!-- currently not used	  
	<xsl:comment>
		<xsl:text>updated by template </xsl:text> <xsl:value-of select="$structureName"/><xsl:text> Mode: </xsl:text><xsl:value-of select="$myMode"/><xsl:text> </xsl:text>
		<xsl:value-of select="user:GetCurrentDateTime()"/>
		<xsl:text> converted from </xsl:text><xsl:value-of select="$ConvertedFrom"/><xsl:text> to </xsl:text><xsl:value-of select="$newversion"/>
	</xsl:comment>
-->
  </xsl:template>
  <!-- -->
  <xsl:template name="InsertTrace">
	  <xsl:param name="traceText"/>
<!-- currently not used	  
	<xsl:comment>
		<xsl:text>TRACE: </xsl:text> <xsl:value-of select="$traceText"/>
	</xsl:comment>
-->
  </xsl:template>
  <!-- -->
  <!-- Compare versions strings of form 'major.minor.sub' by script; same function as in create-net.xsl -->
  <msxsl:script language="javascript" implements-prefix="user">
	<![CDATA[
   function IsVersionLess(left,right)
   {
	   var erg = IsVersionGreaterOrEqual(left,right);
	   return !erg;
   }
   function IsVersionLessX(left,right)
   {
      // version strings of the form aa.bb.cc can be compared
      // aa bb cc may only contain 2 digits
      var versionLeft = 0;
      var versionRight = 0;
      var tokenLeft = left.split(".");
      versionLeft = Number(tokenLeft[0]) * 10000;
      versionLeft += Number(tokenLeft[1]) * 100;
      versionLeft += Number(tokenLeft[2]);
      var tokenRight = right.split(".");
      versionRight = Number(tokenRight[0]) * 10000;
      versionRight += Number(tokenRight[1]) * 100;
      versionRight += Number(tokenRight[2]);
      if (versionLeft >= versionRight)
      {
		  return false;
      }
      else
      {
		  return true;
      }
   }
   function IsVersionGreaterOrEqual(left,right)
   {
      // version strings of the form aa.bb.cc can be compared
      // aa bb cc may only contain 2 digits
      var versionLeft = 0;
      var versionRight = 0;
      var tokenLeft = left.split(".");
      versionLeft = Number(tokenLeft[0]) * 10000;
      versionLeft += Number(tokenLeft[1]) * 100;
      versionLeft += Number(tokenLeft[2]);
      var tokenRight = right.split(".");
      versionRight = Number(tokenRight[0]) * 10000;
      versionRight += Number(tokenRight[1]) * 100;
      versionRight += Number(tokenRight[2]);
      return versionLeft >= versionRight;
   }
	function GetCurrentDateTime()
    {
        var currentTime = new Date();
        var month = currentTime.getMonth() + 1;
        var day = currentTime.getDate();
        var year = currentTime.getFullYear();
        var hour = currentTime.getHours();
        var minute = currentTime.getMinutes();
		return(day + "." + month + "." + year + " " + hour + ":" + ("0" + minute).slice(-2));

    }
   var P2PInserted = "0";
   function SetP2PInserted(value)
   {
	   P2PInserted = value;
	   return P2PInserted;
   }
   function GetP2PInserted()
   {
	   return P2PInserted;
   }
   var cloudInserted = "0";
   function SetCloudInserted(value)
   {
	   cloudInserted = value;
	   return cloudInserted;
   }
   function GetCloudInserted()
   {
	   return cloudInserted;
   }
]]>
</msxsl:script>
</xsl:stylesheet>
